--[[---------------------------------------------------------------------------------------------------
											AutoBongos
											
Description: Minimalistic library to automatic update bars size
Author: Copyright 2008 João Cardoso (Jaliborc)
Contact: jaliborc@gmail.com
Dependencies: LibStub
License: GNU General Public License - Version 3 (<http://www.gnu.org/licenses/> for more information)
--]]------------------------------------------------------------------------------------------------

local lib = LibStub:NewLibrary("AutoBongos-1.0", 3)
local Ace = LibStub("AceAddon-3.0")
local Bongos = Ace:GetAddon("Bongos3")

if not lib then
	return
end

function lib:CreateBar(...)
	local bar, isNew = Bongos.Bar:Create(...)
	Ace:EmbedLibrary(bar, "AceEvent-3.0")
	
	bar.UpdateSize = function() end --no error
	bar:RegisterMessage("BONGOS_LOCK_DISABLE", "UpdateSize")
	bar:RegisterMessage("BONGOS_LOCK_ENABLE", "UpdateSize")
	
	function bar:Attach(frame)
		Bongos.Bar.Attach(self, frame)
		frame.SetPoint = function() end
		frame.SetAllPoints = function() end
		frame.ClearAllPoints = function() end
	end
	
	return bar, isNew
end